<?php
function saveImportServer()
{
   $sock = Login();
   checkActionAccess($sock, "write");

   $object = json_decode(file_get_contents("php://input"), true);
   checkReceivedFile($object);
   if (isset($object["clearServer"])) {
      /* цсу */
      ParamUnset($sock, "server.uplink.ip");
      ParamSetInt($sock, "server.uplink.port", 0);
      /* ntp */
      ParamUnset($sock, "server.ntp.ntpserverip");
      ParamUnset($sock, "server.ntp.ntptzoffset");
      /* snmp */
      ParamSetInt($sock, "server.snmp.enabled", 0);
      ParamSetString($sock, "server.snmp.trapip", "0.0.0.0");
      ParamSetInt($sock, "server.snmp.trapport", 0);
   }
   if (isset($object["clearChannel"])) {
      foreach ($object["clearChannel"] as $index) {
         ParamSetInt($sock, "video.input.[" . $index . "].enabled", 0);
      }
   }
   if (isset($object["settings"])) {
      $servers = $object["settings"];
      foreach ($servers as $server) {
         if ($server["type"]) {
            ParamSetInt($sock, $server["name"], $server["value"]);
         } else {
            ParamSetString($sock, $server["name"], $server["value"]);
         }
      }
      sleep(2);
      foreach ($object["clearChannel"] as $index) {
         ParamSetInt($sock, "video.input.[" . $index . "].enabled", 1);
      }
   }
   if (isset($object["macros"])) {
      $macros = $object["macros"];
      $index = 0;
      foreach ($macros as $macro) {
         usleep(200000);
         ParamSetString($sock, "macros" . $index, $macro);
         $index += 1;
      }
   }
   if (isset($object["events"])) {
      $events = $object["events"];
      ParamSetString($sock, "eventlist", $events);
   }
   socket_close($sock);
}
function saveImportExcelServer()
{
   $sock = Login();
   checkActionAccess($sock, "write");

   $object = json_decode(file_get_contents("php://input"), true);
   checkReceivedFile($object);

   if (isset($object["clearChannel"])) {
      foreach ($object["clearChannel"] as $index) {
         ParamSetInt($sock, "video.input.[" . $index . "].enabled", 0);
      }
   }
   if (isset($object["settings"])) {
      $servers = $object["settings"];
      foreach ($servers as $server) {
         if ($server["type"]) {
            ParamSetInt($sock, $server["path"], $server["value"]);
         } else {
            ParamSetString($sock, $server["path"], $server["value"], $server["isNeedConvert"]);
         }
      }
      sleep(2);
      foreach ($object["clearChannel"] as $index) {
         ParamSetInt($sock, "video.input.[" . $index . "].enabled", 1);
      }
   }
   socket_close($sock);
}
